unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, ZLib;

type
  TForm3 = class(TForm)
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Image1: TImage;
    GroupBox3: TGroupBox;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OpenFromStream(str:string; obj:TMemo);
    procedure SaveToStream(str:string; obj:TMemo);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses Unit1;

{$R *.dfm}

procedure TForm3.Button1Click(Sender: TObject);
var
  i,x:integer;
begin
  if(TryStrToInt(Edit1.Text,x)=False) then ShowMessage('   !')
  else begin
    Memo1.Lines.Clear();
    Memo1.Lines.Add('---');
    for i:=1 to x do
    begin
     Memo1.Lines.Add(IntToStr(i)+')');
     Memo1.Lines.Add('A)');
     Memo1.Lines.Add('B)');
     Memo1.Lines.Add('C)');
     Memo1.Lines.Add('D)');
     Memo1.Lines.Add('E)');
     Memo1.Lines.Add('---');
    end;
  end;
end;

procedure TForm3.Button2Click(Sender: TObject);
begin

  if (OpenDialog1.Execute=True) then
  begin
    OpenFromStream(OpenDialog1.FileName,Memo1);
  end;

end;

procedure TForm3.Button3Click(Sender: TObject);
begin

  if (SaveDialog1.Execute=True) then
  begin
   SaveToStream(SaveDialog1.FileName,Memo1);
  end;

end;

procedure TForm3.Button4Click(Sender: TObject);
begin
Form3.Close;
Form1.Show;
end;

procedure TForm3.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Edit1.Clear;
Memo1.Clear;
end;

procedure TForm3.OpenFromStream(str: string; obj: TMemo);
var
  AZLib : TDecompressionStream;
  AStream : TFileStream;
  AMemStream : TMemoryStream;
  ALen : Int64;
begin
  AStream := TFileStream.Create(str,fmOpenRead);
  AZLib := TDecompressionStream.Create(AStream);
  AMemStream := TMemoryStream.Create;
  Try
    AZLib.ReadBuffer(ALen,SizeOf(Int64));
    AMemStream.CopyFrom(AZLib,ALen);
    AMemStream.Seek(0,0);
    TMemo(obj).Lines.LoadFromStream(AMemStream);
  Finally
    AMemStream.Free;
    AZLib.Free;
    AStream.Free;
  End;
end;

procedure TForm3.SaveToStream(str: string; obj: TMemo);
var
  AStream : TFileStream;
  AZLib : TCompressionStream;
  AMemStream : TMemoryStream;
  ALen : Int64;
begin
  AStream := TFileStream.Create(str,fmCreate);
  AMemStream := TMemoryStream.Create;
  AZLib := TCompressionStream.Create(clMax,AStream);
  Try
    TMemo(obj).Lines.SaveToStream(AMemStream);
    AMemStream.Seek(0,0);
    ALen := AMemStream.Size;
    AZLib.WriteBuffer(ALen,SizeOf(Int64));
    AZLib.CopyFrom(AMemStream,ALen);
  Finally
    AZLib.Free;
    AStream.Free;
  End;
end;

end.
